package gov.va.med.mhv.health.repository;

import gov.va.med.mhv.health.model.Immunization;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ImmunizationRepository extends JpaRepository<Immunization, Long>{
	
	
    @Query("select a from Immunization a where a.userprofileId = :userprofileid order by a.dateReceived desc")
	 List<Immunization>  getImmunizationsForUser(@Param ("userprofileid") Long userprofileid);
    
    
    @Query("select a from Immunization a where a.userprofileId = :userprofileid order by a.dateReceived desc")
	 List<Immunization>  getDashBoardImmunizationsForUser(@Param ("userprofileid") Long userprofileid,Pageable page);



}
